------------------------------------------------------------
-- Change Composition Depth Globally, Revision: 2.0
--
--
-- This script can set the Color depth of all source tools in
-- the flow to a uniform value, ensuring that all tools are 
-- operating at the same depth.
--
-- The change depth tool is ignored (remove comments below 
-- to include), and you will have to include third party source 
-- tools like vlam, jaws, or lines yourself, if they are installed.

-- place in Fusion:\Scripts\Comp 
--
-- TODO : Store old color depths in tool data for restore?
--
-- written by Isaac Guenard (izyk@eyeonline.com) / edited for 5 by Sean Konrad
-- created : May 21st, 2003
-- updated : Sept 27, 2005
-- changes : updated for 5
------------------------------------------------------------

-- set up a table of source tools
-- loader is excluded because it has an extra 
-- option for color depth called Format, so we 
-- handle that seperately.


depths = {"Format", "Default", "int8", "int16", "float16", "float32"}

ret = AskUser("Global Change Depth", {	
	{"Depth",  "Dropdown", Options = depths},
	{"Selected", Name = "Affect Selected Tools Only", "Checkbox", Default = 0}
	})

if ret then
	print()
	print("Changing Source Tool Color Depths to ".. depths[ret.Depth + 1])
	print("---------------------------------------------------")
	print()

	-- ((ret.Selected ==1)) will return true if the 
	-- selected checkbox is enabled.....
	
	for i, v in pairs(composition:GetToolList((ret.Selected == 1))) do
		id = v:GetAttrs().TOOLS_RegID

		if id == "Loader" then
			v.Depth = ret.Depth
			print(v:GetAttrs().TOOLS_Name)
		else
			if ret.Depth > 0 then
				if v:GetReg():IsClassType("SourceOperator") then
					v.Depth = ret.Depth - 1
					print(v:GetAttrs().TOOLS_Name)
				end
			end
		end
	end
	
end
print()
